/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import io.github.foundationgames.automobility.recipe.ContainerRecipeInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AutoMechanicTableScreenHandler
extends AbstractContainerMenu {
    private final Level world;
    private final ContainerLevelAccess context;
    private final DataSlot selectedRecipe = DataSlot.standalone();
    public List<AutoMechanicTableRecipe> recipes;
    public final List<Ingredient> missingIngredients = new ArrayList<Ingredient>();
    public final SimpleContainer inputInv;
    public final Slot outputSlot;
    private final int playerInvSlot;

    public AutoMechanicTableScreenHandler(int syncId, Inventory playerInv) {
        this(syncId, playerInv, ContainerLevelAccess.NULL);
    }

    public AutoMechanicTableScreenHandler(int syncId, Inventory playerInv, ContainerLevelAccess ctx) {
        super(Automobility.AUTO_MECHANIC_SCREEN.require("Auto mechanic screen not registered!"), syncId);
        this.world = playerInv.player.level();
        this.context = ctx;
        this.inputInv = new SimpleContainer(9){

            public void setChanged() {
                AutoMechanicTableScreenHandler.this.onInputUpdated();
            }
        };
        for (int s = 0; s < 9; ++s) {
            this.addSlot(new InputSlot((Container)this.inputInv, s, 8 + s * 18, 88));
        }
        this.outputSlot = this.addSlot(new OutputSlot((Container)new SimpleContainer(1), 0, 26, 38));
        this.playerInvSlot = this.slots.size();
        int playerInvY = 127;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        for (int s = 0; s < 9; ++s) {
            this.addSlot(new Slot((Container)playerInv, s, 8 + s * 18, playerInvY + 58));
        }
        this.recipes = this.world.getRecipeManager().getAllRecipesFor(AutoMechanicTableRecipe.TYPE).stream().map(h -> {
            AutoMechanicTableRecipe r = (AutoMechanicTableRecipe)h.value();
            r.sortId = h.id();
            return r;
        }).collect(Collectors.toList());
        Collections.sort(this.recipes);
        this.selectedRecipe.set(-1);
        this.addDataSlot(this.selectedRecipe);
    }

    public Optional<AutoMechanicTableRecipe> getSelectedRecipe() {
        int id = this.selectedRecipe.get();
        return id >= 0 && this.recipes.size() > 0 && id < this.recipes.size() ? Optional.of(this.recipes.get(id)) : Optional.empty();
    }

    public int getSelectedRecipeId() {
        return this.selectedRecipe.get();
    }

    private void updateMissingIngredients() {
        this.missingIngredients.clear();
        ContainerRecipeInput ctr = new ContainerRecipeInput(this.inputInv);
        this.getSelectedRecipe().ifPresent(recipe -> recipe.forMissingIngredients(ctr, this.missingIngredients::add));
    }

    private void updateRecipeState() {
        this.updateMissingIngredients();
        ContainerRecipeInput ctr = new ContainerRecipeInput(this.inputInv);
        this.getSelectedRecipe().ifPresent(recipe -> {
            if (recipe.matches(ctr, this.world)) {
                this.outputSlot.set(recipe.getResultItem().copy());
            } else {
                this.outputSlot.set(ItemStack.EMPTY);
            }
        });
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectRecipe(id);
            return true;
        }
        return super.clickMenuButton(player, id);
    }

    private void onInputUpdated() {
        this.updateRecipeState();
    }

    private void selectRecipe(int id) {
        this.selectedRecipe.set(id);
        this.updateRecipeState();
    }

    public void removed(Player player) {
        super.removed(player);
        this.outputSlot.set(ItemStack.EMPTY);
        this.context.execute((world, pos) -> this.clearContainer(player, (Container)this.inputInv));
    }

    public boolean stillValid(Player player) {
        return AutoMechanicTableScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)AutomobilityBlocks.AUTO_MECHANIC_TABLE.require());
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.outputSlot && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int fromSlotId) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot fromSlot = (Slot)this.slots.get(fromSlotId);
        if (fromSlot.hasItem()) {
            ItemStack fromStack = fromSlot.getItem();
            Item fromItem = fromStack.getItem();
            newStack = fromStack.copy();
            if (fromSlotId == this.outputSlot.index) {
                fromItem.onCraftedBy(fromStack, player.level(), player);
                if (!this.moveItemStackTo(fromStack, this.playerInvSlot, this.playerInvSlot + 36, true)) {
                    return ItemStack.EMPTY;
                }
                fromSlot.onQuickCraft(fromStack, newStack);
            } else if (this.slots.stream().anyMatch(s -> s.container == this.inputInv && s.index == fromSlotId) ? !this.moveItemStackTo(fromStack, this.playerInvSlot, this.playerInvSlot + 36, false) : (this.missingIngredients.stream().anyMatch(ing -> ing.test(fromStack)) ? !this.moveItemStackTo(fromStack, 0, 8, false) : (fromSlotId >= this.playerInvSlot && fromSlotId < this.playerInvSlot + 27 ? !this.moveItemStackTo(fromStack, this.playerInvSlot + 27, this.playerInvSlot + 36, false) : fromSlotId >= this.playerInvSlot + 27 && fromSlotId < this.playerInvSlot + 36 && !this.moveItemStackTo(fromStack, this.playerInvSlot, this.playerInvSlot + 27, false)))) {
                return ItemStack.EMPTY;
            }
            if (fromStack.isEmpty()) {
                fromSlot.set(ItemStack.EMPTY);
            }
            fromSlot.setChanged();
            if (fromStack.getCount() == newStack.getCount()) {
                return ItemStack.EMPTY;
            }
            fromSlot.onTake(player, fromStack);
            this.broadcastChanges();
        }
        return newStack;
    }

    public static class InputSlot
    extends Slot {
        public InputSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }
    }

    public class OutputSlot
    extends Slot {
        public OutputSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public void onTake(Player player, ItemStack stack) {
            super.onTake(player, stack);
            AutoMechanicTableScreenHandler.this.getSelectedRecipe().ifPresent(recipe -> {
                recipe.assemble(new ContainerRecipeInput(AutoMechanicTableScreenHandler.this.inputInv));
                stack.getItem().onCraftedBy(stack, player.level(), player);
                AutoMechanicTableScreenHandler.this.updateRecipeState();
            });
        }
    }
}

